/**
 * 
 */
package gov.va.med.mhv.usermgmt.main.service.impl;

import java.util.StringTokenizer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.HtmlEmail;

import gov.va.med.mhv.usermgmt.service.EmailFailureException;
import gov.va.med.mhv.usermgmt.service.EmailService;

/**
 * @author vhaislegberb
 *
 */
public class CommonsHtmlEmailService implements EmailService {
	
	private static final Log LOG = LogFactory.getLog(CommonsHtmlEmailService.class);
	
	private static final String EMAIL_DELIM_CHAR = ",";
	
	private String smtpHost;
	
	private Boolean smtpDebug;
	
	private String bccEmailAddresses;
	

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.mhv.usermgmt.service.EmailService#send(java.lang.String,
	 * java.lang.String, java.lang.String, java.lang.String, java.lang.String,
	 * java.lang.String)
	 */
	@Override
	public boolean send(String from, String fromName, String subject, String message, String recipient, String messageContentType) throws EmailFailureException {
		
		HtmlEmail email = new HtmlEmail();

		try {
			email.setSubject(subject);
			email.setHostName(smtpHost);
			email.setDebug(smtpDebug);
			email.setHtmlMsg(message);
			
			StringTokenizer toTok = new StringTokenizer(recipient, EMAIL_DELIM_CHAR);
			while(toTok.hasMoreTokens()) {
				email.addTo(toTok.nextToken());
			}

			email.setFrom(from);

			
			if (bccEmailAddresses != null && bccEmailAddresses.length() > 0) {
				StringTokenizer bccTok = new StringTokenizer(bccEmailAddresses, EMAIL_DELIM_CHAR);
				while(bccTok.hasMoreTokens()) {
					email.addBcc(bccTok.nextToken());
				}
			}

			email.setMsg(message);
			email.send();
		} catch (Exception e) {
			String errMsg = String.format("Error sending message: %s", e.getMessage());
			LOG.error(errMsg);
			throw new EmailFailureException(errMsg, e);
		}

		return true;
	}
	
	public void setBccEmailAddresses(String bccEmailAddress) {
		this.bccEmailAddresses = bccEmailAddress;
	}
	
	public void setSmtpHost(String smtpHost) {
		this.smtpHost = smtpHost;
	}
	
	public void setSmtpDebug(Boolean smtpDebug) {
		this.smtpDebug = smtpDebug;
	}

}
